<#ibiztemplate>
TARGET=PSAPPVIEWCTRL_CALENDAR
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.vo;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName};
import lombok.Data;
import java.util.ArrayList;
import java.util.List;
import java.sql.Timestamp;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ${de.codeName}_Calendar_${ctrl.codeName}{

    //前台传入的开始时间
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JsonProperty(access=Access.WRITE_ONLY)
    private Timestamp srfbegintime;
    //前台传入的结束时间
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JsonProperty(access=Access.WRITE_ONLY)
    private Timestamp srfendtime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp begintime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    private Timestamp endtime;
    private String icon;
    private String hrefTarget;
    private String text;
    private String cls;
    private String type;
    private String srfkey;
    private String srfmajortext;
    private String iconCls;
    private String bkcolor;
    private String id;
    private String content;
    private String color;
    private String href;
    private String qtip;
    private boolean disabled;

<#list ctrl.getPSSysCalendarItems() as calendards>
    <#assign calendarEntity=calendards.getPSDataEntity()>
    /**
     * 日历部件[${calendards.name}]设置数据源查询条件
     * @param searchFilter
     * @return
     */
    public ${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.service.dto.${calendarEntity.codeName}SearchFilter get${calendarEntity.codeName}SearchFilter(${de.codeName}_Calendar_${ctrl.codeName} searchFilter) {
        ${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.service.dto.${calendarEntity.codeName}SearchFilter filter=new ${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.service.dto.${calendarEntity.codeName}SearchFilter();
        QueryWrapper<${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.domain.${calendarEntity.getCodeName()}> qw =filter.getSelectCond();
        qw.ge("${calendards.getBeginTimePSDEField().name?lower_case}",srfbegintime);
        qw.le("${calendards.getEndTimePSDEField().name?lower_case}",srfendtime);
        return filter;
    }
    /**
    * 日历部件[${calendards.name}]将数据源结果填入list集合中
    * @param
    * @param records
    */
    public void add${calendarEntity.codeName}ToRecords(Page<${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.domain.${calendarEntity.getCodeName()}> ${calendarEntity.codeName?lower_case}SearchResult, List<${de.codeName}_Calendar_${ctrl.codeName}> records) {
        for(${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.domain.${calendarEntity.getCodeName()} source:${calendarEntity.codeName?lower_case}SearchResult.getRecords()) {
        ${de.codeName}_Calendar_${ctrl.codeName} target=new ${de.codeName}_Calendar_${ctrl.codeName}();
        target.from${calendarEntity.codeName}(source);
        records.add(target);
        }
     }
    /**
    * 日历部件[${calendards.name}]数据源结果vo对象转换
    * @param sourceEntity
    */
    public  void from${calendarEntity.codeName}(${pub.getPKGCodeName()}.${calendarEntity.getPSSystemModule().codeName?lower_case}.domain.${calendarEntity.getCodeName()} sourceEntity)  {
        this.setEndtime(sourceEntity.get${calendards.getEndTimePSDEField().codeName?lower_case?cap_first}());
        this.setIcon("");
        this.setHrefTarget("");
        this.setText("");
        this.setCls("");
        this.setBegintime(sourceEntity.get${calendards.getBeginTimePSDEField().codeName?lower_case?cap_first}());
        this.setType("${calendards.getItemType()}");
        this.setSrfkey(sourceEntity.get${calendarEntity.getKeyPSDEField().codeName?lower_case?cap_first}());
        this.setSrfmajortext(sourceEntity.get${calendarEntity.getMajorPSDEField().codeName?lower_case?cap_first}());
        this.setIconCls("");
        this.setBkcolor("${calendards.getBKColor()}");
        this.setId(sourceEntity.get${calendarEntity.getKeyPSDEField().codeName?lower_case?cap_first}());
        this.setContent(sourceEntity.get${calendarEntity.getMajorPSDEField().codeName?lower_case?cap_first}());
        this.setColor("${calendards.getColor()}");
        this.setHref("");
        this.setQtip("");
        this.setDisabled(false);
    }
</#list>
    /**
    * 将全部数据源结果集封装成page对象
    * @param records
    * @return
    */
    public Page<${de.codeName}_Calendar_${ctrl.codeName}> addRecordsToPage(List<${de.codeName}_Calendar_${ctrl.codeName}> records) {
        Page<${de.codeName}_Calendar_${ctrl.codeName}> targetpage=new Page<${de.codeName}_Calendar_${ctrl.codeName}>(0,0,records.size(),false);
            targetpage.setAsc(null);
            targetpage.setDesc(null);
            targetpage.setOptimizeCountSql(false);
            targetpage.setRecords(records);
            return targetpage;
        }
}